/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PImage;
import processing.sound.Amplitude;
import processing.sound.AudioIn;
import processing.sound.SoundObject;

public class Scream2Mute
extends PApplet {
    AudioIn mic;
    Amplitude amp;
    PImage logo;
    float threshold = 0.25f;
    boolean isMuted = false;
    int muteTimer = 0;
    int muteDuration = 3000;

    public void setup() {
        this.logo = this.loadImage("logo.png");
        this.mic = new AudioIn((PApplet)this, 0);
        this.mic.start();
        this.amp = new Amplitude((PApplet)this);
        this.amp.input((SoundObject)this.mic);
    }

    public void draw() {
        float level = this.amp.analyze();
        float intensity = Scream2Mute.constrain((float)Scream2Mute.map((float)level, (float)0.0f, (float)0.5f, (float)0.0f, (float)1.0f), (float)0.0f, (float)1.0f);
        this.background(15);
        this.drawReactiveLogo(intensity);
        this.drawSoundBurst(intensity);
        if (level > this.threshold && !this.isMuted) {
            this.muteSystem();
            this.isMuted = true;
            this.muteTimer = this.millis();
        }
        if (this.isMuted && this.millis() - this.muteTimer > this.muteDuration) {
            this.unmuteSystem();
            this.isMuted = false;
        }
    }

    public void drawReactiveLogo(float intensity) {
        this.pushMatrix();
        this.translate(this.width / 2, this.height / 2);
        this.imageMode(3);
        this.tint(255.0f, 255.0f - intensity * 150.0f, 255.0f - intensity * 150.0f);
        float shake = intensity * 10.0f;
        this.image(this.logo, this.random(-shake, shake), this.random(-shake, shake), 400.0f, 400.0f);
        this.noTint();
        this.popMatrix();
        if (intensity > 0.4f) {
            this.drawSquint(intensity);
        }
    }

    public void drawSquint(float intensity) {
        this.pushMatrix();
        this.translate(this.width / 2, this.height / 2 - 80);
        this.fill(0, 150.0f);
        this.noStroke();
        float squintAmount = Scream2Mute.map((float)intensity, (float)0.4f, (float)1.0f, (float)0.0f, (float)25.0f);
        this.ellipse(-70.0f, 0.0f, 60.0f, squintAmount);
        this.ellipse(70.0f, 0.0f, 60.0f, squintAmount);
        this.popMatrix();
    }

    public void drawSoundBurst(float intensity) {
        if (intensity < 0.35f) {
            return;
        }
        this.pushMatrix();
        this.translate(this.width / 2 + 90, this.height / 2 + 40);
        this.stroke(255.0f, 50.0f, 0.0f);
        this.strokeWeight(8.0f);
        this.noFill();
        float size = Scream2Mute.map((float)intensity, (float)0.35f, (float)1.0f, (float)40.0f, (float)260.0f);
        int i = 0;
        while (i < 5) {
            float pulse = Scream2Mute.sin((float)((float)this.frameCount * 0.3f + (float)i)) * 10.0f;
            this.arc(0.0f, 0.0f, size + (float)(i * 25) + pulse, size + (float)(i * 25) + pulse, -0.62831855f, 0.62831855f);
            ++i;
        }
        this.popMatrix();
    }

    public void muteSystem() {
        try {
            Runtime.getRuntime().exec(new String[]{"osascript", "-e", "set volume output muted true"});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unmuteSystem() {
        try {
            Runtime.getRuntime().exec(new String[]{"osascript", "-e", "set volume output muted false"});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void settings() {
        this.size(500, 500);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"Scream2Mute"};
        if (passedArgs != null) {
            PApplet.main((String[])Scream2Mute.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

