/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.devices.AudioDeviceFactory;
import com.jsyn.devices.AudioDeviceManager;
import com.jsyn.devices.javasound.JavaSoundAudioDevice;
import com.jsyn.devices.jportaudio.JPortAudioDevice;
import com.jsyn.engine.SynthesisEngine;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.ChannelOut;
import com.jsyn.unitgen.Multiply;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.unitgen.UnitSource;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import processing.core.PApplet;
import processing.sound.JSynAndroidAudioDeviceManager;
import processing.sound.Modulator;

class Engine {
    static boolean verbose = false;
    private static Engine singleton;
    protected Synthesizer synth;
    boolean hasBeenUsed = false;
    protected final Set<UnitGenerator> addedUnits = new HashSet<UnitGenerator>();
    protected ChannelOut[] output;
    private Multiply[] volume;
    private int sampleRate = 44100;
    protected int inputDevice = -1;
    protected int outputDevice = -1;
    protected int outputChannel;
    protected boolean multiChannelMode = false;
    private Callback registeredCallback;

    private static AudioDeviceManager createDefaultAudioDeviceManager() {
        try {
            Class.forName("javax.sound.sampled.AudioSystem");
            return AudioDeviceFactory.createAudioDeviceManager((boolean)true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return new JSynAndroidAudioDeviceManager();
        }
    }

    private static AudioDeviceManager createAudioDeviceManager(boolean bl) {
        Object object;
        if (!bl) {
            object = Engine.createDefaultAudioDeviceManager();
            if (object.getDefaultOutputDeviceID() != -1) {
                return object;
            }
            Engine.printMessage("Didn't find any output devices with the default driver, trying PortAudio...");
        }
        object = System.out;
        PrintStream printStream = System.err;
        if (!verbose) {
            System.setOut(new PrintStream(new OutputStream(){

                @Override
                public void write(int n) {
                }
            }));
            System.setErr(new PrintStream(new OutputStream(){

                @Override
                public void write(int n) {
                }
            }));
        }
        try {
            System.loadLibrary("portaudio_x64");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        try {
            JPortAudioDevice jPortAudioDevice = new JPortAudioDevice();
            return jPortAudioDevice;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (unsatisfiedLinkError.getMessage().contains("disallowed")) {
                throw new RuntimeException("in order to use the PortAudio drivers, you need to give Processing permission to open the PortAudio library file.\n\n============================== ENABLING PORTAUDIO ON MAC OS X ==============================\n\nPlease follow these steps to enable PortAudio (dont worry, you only need to do this once):\n\n  - if you pressed 'Move to Bin' in the previous popup, you will need first need to restore the\n    library file: please find libjportaudio.jnilib in your Bin, right click and select 'Put Back'\n\n  - go to System Preferences > Security & Privacy> General. At the bottom you will see\na message saying that 'libjportaudio.jnilib was blocked'. Press 'Allow Anyway'. When you\nrun this sketch again you should get another popup, just select 'Open' and you're done!\n\n============================================================================================");
            }
            if (verbose) {
                unsatisfiedLinkError.printStackTrace();
            }
            throw new RuntimeException("PortAudio is not supported on this operating system/architecture");
        }
        finally {
            System.setOut((PrintStream)object);
            System.setErr(printStream);
        }
    }

    static Engine getEngine() {
        return Engine.getEngine(null);
    }

    static Engine getEngine(PApplet pApplet) {
        return Engine.getEngine(pApplet, false);
    }

    static Engine getEngine(PApplet pApplet, boolean bl) {
        if (singleton == null) {
            singleton = new Engine(Engine.createAudioDeviceManager(bl));
        }
        if (pApplet != null) {
            singleton.registerWithParent(pApplet);
        }
        return singleton;
    }

    static AudioDeviceManager getAudioDeviceManager() {
        return Engine.getEngine().synth.getAudioDeviceManager();
    }

    private Engine(AudioDeviceManager audioDeviceManager) {
        this(audioDeviceManager, -1);
    }

    private Engine(AudioDeviceManager audioDeviceManager, int n) {
        Logger logger = Logger.getLogger(SynthesisEngine.class.getName());
        logger.setLevel(Level.WARNING);
        this.createSynth(audioDeviceManager);
        this.selectOutputDevice(n);
        this.selectInputDevice(-1);
    }

    private void createSynth(AudioDeviceManager audioDeviceManager) {
        if (this.synth != null) {
            this.stopSynth();
            if (this.hasBeenUsed) {
                Engine.printWarning("Switching audio device drivers. Any previously created Sound library objects can not be used any more!");
                Engine.printWarning("To remove this error messge, make sure to call Sound.outputDevice(...) at the very top of your setup()");
                this.hasBeenUsed = false;
            }
        }
        this.synth = JSyn.createSynthesizer((AudioDeviceManager)audioDeviceManager);
    }

    public boolean isUsingPortAudio() {
        return this.synth.getAudioDeviceManager() instanceof JPortAudioDevice;
    }

    protected boolean usePortAudio(boolean bl) {
        if (bl != this.isUsingPortAudio()) {
            this.createSynth(Engine.createAudioDeviceManager(bl));
            this.inputDevice = -1;
        }
        return this.isUsingPortAudio();
    }

    private void stopSynth() {
        if (this.synth.isRunning()) {
            this.synth.stop();
            for (ChannelOut channelOut : this.output) {
                channelOut.stop();
                channelOut.input.disconnectAll();
                this.synth.remove((UnitGenerator)channelOut);
            }
            this.output = null;
            for (ChannelOut channelOut : this.volume) {
                channelOut.stop();
                channelOut.inputA.disconnectAll();
                this.synth.remove((UnitGenerator)channelOut);
            }
            this.volume = null;
        }
    }

    private void startSynth() {
        int n;
        this.stopSynth();
        this.output = new ChannelOut[this.synth.getAudioDeviceManager().getMaxOutputChannels(this.outputDevice)];
        this.volume = new Multiply[this.synth.getAudioDeviceManager().getMaxOutputChannels(this.outputDevice)];
        for (n = 0; n < this.output.length; ++n) {
            this.output[n] = new ChannelOut();
            this.output[n].setChannelIndex(n);
            this.synth.add((UnitGenerator)this.output[n]);
            this.output[n].start();
            this.volume[n] = new Multiply();
            this.volume[n].output.connect(this.output[n].input);
            this.synth.add((UnitGenerator)this.volume[n]);
        }
        this.setVolume(1.0);
        n = this.inputDevice >= 0 ? this.synth.getAudioDeviceManager().getMaxInputChannels(this.inputDevice) : 0;
        this.synth.start(this.sampleRate, this.inputDevice, n, this.outputDevice, this.synth.getAudioDeviceManager().getMaxOutputChannels(this.outputDevice));
    }

    protected void setSampleRate(int n) {
        this.sampleRate = n;
        this.startSynth();
    }

    private boolean isValidDeviceId(int n) {
        if (n >= 0 && n < this.synth.getAudioDeviceManager().getDeviceCount()) {
            return true;
        }
        Engine.printError("not a valid device id: " + n);
        return false;
    }

    private boolean checkDeviceHasInputs(int n) {
        return this.synth.getAudioDeviceManager().getMaxInputChannels(n) > 0;
    }

    protected int selectInputDevice(int n) {
        if (n == -1) {
            int n2 = this.synth.getAudioDeviceManager().getDefaultInputDeviceID();
            if (n2 == -1) {
                Engine.printWarning("Did not find any sound devices with input channels, you won't be able to use the AudioIn class");
            } else if (!this.getDeviceName(n2).contains("WDM-KS")) {
                try {
                    this.selectInputDevice(this.synth.getAudioDeviceManager().getDefaultInputDeviceID());
                }
                catch (RuntimeException runtimeException) {
                    Engine.printWarning("failed to initialise default input device '" + this.getDeviceName(n) + "' (" + runtimeException.getMessage() + ")");
                    this.inputDevice = -1;
                    this.startSynth();
                }
            }
        } else if (this.isValidDeviceId(n)) {
            if (this.checkDeviceHasInputs(n)) {
                int n3 = this.inputDevice;
                this.inputDevice = n;
                this.startSynth();
            } else {
                Engine.printError("audio device #" + n + " has no input channels");
            }
        }
        return this.inputDevice;
    }

    private boolean checkDeviceHasOutputs(int n) {
        return this.synth.getAudioDeviceManager().getMaxOutputChannels(n) > 1;
    }

    private void probeDeviceOutputLine(int n, int n2) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, new AudioFormat(n2, 16, 2, true, false));
        Line line = AudioSystem.getMixer(AudioSystem.getMixerInfo()[n]).getLine(info);
        line.open();
        line.close();
    }

    protected int selectOutputDevice(int[] nArray) {
        for (int n : nArray) {
            try {
                return this.selectOutputDevice(n);
            }
            catch (RuntimeException runtimeException) {
            }
        }
        throw new RuntimeException("failed to play to any of the output devices");
    }

    protected int selectOutputDevice(int n) {
        if (n == -1) {
            try {
                return this.selectOutputDevice(IntStream.concat(IntStream.of(this.synth.getAudioDeviceManager().getDefaultOutputDeviceID()), IntStream.range(0, this.synth.getAudioDeviceManager().getDeviceCount())).toArray());
            }
            catch (RuntimeException runtimeException) {
                throw new RuntimeException("Could not find any supported audio devices with a stereo output");
            }
        }
        if (!this.isValidDeviceId(n) || this.outputDevice == n) {
            return this.outputDevice;
        }
        if (this.synth.getAudioDeviceManager() instanceof JavaSoundAudioDevice) {
            try {
                this.probeDeviceOutputLine(n, this.sampleRate);
            }
            catch (LineUnavailableException lineUnavailableException) {
                String string = this.getDeviceName(n);
                Engine.printMessage("Output device '" + string + "' did not work with the default audio driver, trying again with PortAudio...");
                try {
                    this.usePortAudio(true);
                }
                catch (RuntimeException runtimeException) {
                    throw new RuntimeException(lineUnavailableException);
                }
                int n2 = this.synth.getAudioDeviceManager().getDefaultOutputDeviceID();
                try {
                    n2 = this.getDeviceIdByName(string, true);
                    if (n2 != n) {
                        Engine.printMessage("Note that the device id of '" + string + "' has changed from " + n + " to " + n2 + ".");
                        Engine.printMessage("If output is working as expected, you can safely ignore this message.");
                        Engine.printMessage("If something is awry, check the output of Sound.list() *after* the call to Sound.selectOutputDevice()");
                    }
                }
                catch (RuntimeException runtimeException) {
                    Engine.printMessage("Switched to new default output device '" + this.getDeviceName(n2) + "'");
                }
                return this.selectOutputDevice(n2);
            }
        }
        if (this.checkDeviceHasOutputs(n)) {
            this.outputDevice = n;
            this.startSynth();
        } else {
            Engine.printWarning("audio device '" + this.getDeviceName(n) + "' has no stereo output channel");
        }
        return this.outputDevice;
    }

    protected String getDeviceName(int n) {
        return this.isValidDeviceId(n) ? this.synth.getAudioDeviceManager().getDeviceName(n).trim() : "";
    }

    protected int getDeviceIdByName(String string) {
        for (int i = 0; i < this.synth.getAudioDeviceManager().getDeviceCount(); ++i) {
            if (!string.equalsIgnoreCase(this.getDeviceName(i))) continue;
            return i;
        }
        throw new RuntimeException("No audio device with name '" + string + "' found.");
    }

    protected int getDeviceIdByName(String string, boolean bl) {
        try {
            return this.getDeviceIdByName(string);
        }
        catch (RuntimeException runtimeException) {
            if (bl) {
                for (int i = 0; i < this.synth.getAudioDeviceManager().getDeviceCount(); ++i) {
                    if (!this.getDeviceName(i).startsWith(string)) continue;
                    return i;
                }
            }
            throw runtimeException;
        }
    }

    protected int selectOutputChannel(int n) {
        if (n == -1) {
            this.outputChannel = 0;
            this.multiChannelMode = false;
        } else if (n < 0 || n > this.synth.getAudioDeviceManager().getMaxOutputChannels(this.outputDevice)) {
            Engine.printError("Invalid channel #" + n + ", current output device only has " + this.synth.getAudioDeviceManager().getMaxOutputChannels(this.outputDevice) + " channels");
        } else {
            this.outputChannel = n;
            this.multiChannelMode = true;
        }
        return this.outputChannel;
    }

    protected String getSelectedInputDeviceName() {
        return this.getDeviceName(this.inputDevice);
    }

    protected String getSelectedOutputDeviceName() {
        return this.getDeviceName(this.outputDevice);
    }

    protected void setVolume(double d) {
        if (Engine.checkRange(d, "volume")) {
            for (Multiply multiply : this.volume) {
                multiply.inputB.set(d);
            }
        }
    }

    protected int getSampleRate() {
        return this.synth.getFrameRate();
    }

    protected void add(UnitGenerator unitGenerator) {
        if (!this.addedUnits.contains(unitGenerator)) {
            this.synth.add(unitGenerator);
            this.addedUnits.add(unitGenerator);
        }
    }

    protected void remove(UnitGenerator unitGenerator) {
        if (this.addedUnits.contains(unitGenerator)) {
            this.synth.remove(unitGenerator);
            this.addedUnits.remove(unitGenerator);
        }
    }

    protected void connectToOutput(int n, UnitSource unitSource) {
        this.connectToOutput(n, unitSource, 0);
    }

    protected void connectToOutput(int n, UnitSource unitSource, int n2) {
        unitSource.getOutput().connect(n2, this.volume[n].inputA, 0);
    }

    protected void disconnectFromOutput(int n, UnitSource unitSource) {
        this.disconnectFromOutput(n, unitSource, 0);
    }

    protected void disconnectFromOutput(int n, UnitSource unitSource, int n2) {
        unitSource.getOutput().disconnect(n2, this.volume[n].inputA, 0);
    }

    protected void disconnectFromOutput(UnitSource unitSource) {
        for (Multiply multiply : this.volume) {
            for (int i = 0; i < unitSource.getOutput().getNumParts(); ++i) {
                unitSource.getOutput().disconnect(i, multiply.inputA, 0);
            }
        }
    }

    protected void play(UnitSource unitSource) {
        UnitGenerator unitGenerator = unitSource.getUnitGenerator();
        this.add(unitGenerator);
        for (int i = 0; i < unitSource.getOutput().getNumParts(); ++i) {
            this.connectToOutput((this.outputChannel + i) % this.synth.getAudioDeviceManager().getMaxOutputChannels(this.outputDevice), unitSource, i);
            if (this.multiChannelMode) break;
        }
    }

    protected void stop(UnitSource unitSource) {
        if (this.addedUnits.contains(unitSource.getUnitGenerator())) {
            this.disconnectFromOutput(unitSource);
            if (!unitSource.getOutput().isConnected()) {
                this.remove(unitSource.getUnitGenerator());
            }
        }
    }

    private void registerWithParent(PApplet pApplet) {
        if (this.registeredCallback != null) {
            return;
        }
        this.registeredCallback = new Callback();
        pApplet.registerMethod("dispose", (Object)this.registeredCallback);
        pApplet.registerMethod("pause", (Object)this.registeredCallback);
        pApplet.registerMethod("resume", (Object)this.registeredCallback);
    }

    protected static void setModulation(UnitInputPort unitInputPort, Modulator modulator) {
        if (modulator == null) {
            unitInputPort.disconnectAll();
        } else {
            unitInputPort.setValueAdded(true);
            unitInputPort.connect(modulator.getModulator());
        }
    }

    protected static boolean checkAmp(float f) {
        if (f < -1.0f || f > 1.0f) {
            Engine.printError("amplitude has to be in [-1,1]");
            return false;
        }
        if ((double)f == 0.0) {
            Engine.printWarning("an amplitude of 0 means this sound is not audible now");
        }
        return true;
    }

    protected static boolean checkPan(float f) {
        if (f < -1.0f || f > 1.0f) {
            Engine.printError("pan has to be in [-1,1]");
            return false;
        }
        return true;
    }

    protected static boolean checkRange(double d, String string) {
        if (d < 0.0 || d > 1.0) {
            Engine.printError(string + " parameter has to be between 0 and 1 (inclusive)");
            return false;
        }
        return true;
    }

    protected static void println(String string) {
        PApplet.println((String)string);
    }

    protected static void println() {
        Engine.println("");
    }

    protected static void printMessage(String string) {
        Engine.println("Sound library: " + string);
    }

    protected static void printWarning(String string) {
        Engine.println("Sound library warning: " + string);
    }

    protected static void printError(String string) {
        Engine.println("Sound library error: " + string);
    }

    public class Callback {
        public void dispose() {
            Engine.this.synth.stop();
        }

        public void pause() {
        }

        public void resume() {
        }
    }
}

