/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import com.jsyn.data.SegmentedEnvelope;
import com.jsyn.data.SequentialData;
import com.jsyn.ports.QueueDataCommand;
import com.jsyn.ports.QueueDataEvent;
import com.jsyn.ports.UnitDataQueueCallback;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.unitgen.VariableRateMonoReader;
import com.softsynth.shared.time.ScheduledCommand;
import processing.core.PApplet;
import processing.sound.Engine;
import processing.sound.SoundObject;

public class Env {
    public Env(PApplet pApplet) {
        Engine.getEngine(pApplet);
    }

    public void play(final SoundObject soundObject, float f, float f2, float f3, float f4) {
        SegmentedEnvelope segmentedEnvelope = new SegmentedEnvelope(new double[]{f, soundObject.amp, f2, f3 * soundObject.amp, f4, 0.0});
        final VariableRateMonoReader variableRateMonoReader = new VariableRateMonoReader();
        Engine.getEngine().add((UnitGenerator)variableRateMonoReader);
        variableRateMonoReader.start();
        soundObject.amplitude.disconnectAll();
        variableRateMonoReader.output.connect(soundObject.amplitude);
        if (!soundObject.isPlaying()) {
            soundObject.play();
        }
        QueueDataCommand queueDataCommand = variableRateMonoReader.dataQueue.createQueueDataCommand((SequentialData)segmentedEnvelope, 0, segmentedEnvelope.getNumFrames());
        queueDataCommand.setAutoStop(true);
        queueDataCommand.setCallback(new UnitDataQueueCallback(){

            public void finished(QueueDataEvent queueDataEvent) {
                if (variableRateMonoReader.output.isConnected()) {
                    variableRateMonoReader.output.disconnectAll();
                    soundObject.amplitude.set(0.0);
                }
                Engine.getEngine().remove((UnitGenerator)variableRateMonoReader);
            }

            public void looped(QueueDataEvent queueDataEvent) {
            }

            public void started(QueueDataEvent queueDataEvent) {
            }
        });
        variableRateMonoReader.getSynthesizer().queueCommand((ScheduledCommand)queueDataCommand);
    }
}

