/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.Circuit;
import com.jsyn.unitgen.TwoInDualOut;
import com.jsyn.unitgen.UnitFilter;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.unitgen.UnitSource;
import processing.sound.Effect;
import processing.sound.JSynProcessor;

public class JSynCircuit
extends Circuit
implements UnitSource {
    private UnitGenerator source;
    protected JSynProcessor processor;
    protected UnitOutputPort preEffect;
    protected Effect<? extends UnitFilter> effect;
    protected TwoInDualOut output = new TwoInDualOut();

    public JSynCircuit(UnitOutputPort unitOutputPort) {
        this.add((UnitGenerator)this.output);
        this.source = unitOutputPort.getUnitGenerator();
        this.add(this.source);
        if (unitOutputPort.getNumParts() == 2) {
            this.preEffect = unitOutputPort;
        } else {
            this.processor = new JSynProcessor();
            this.add((UnitGenerator)this.processor);
            this.processor.input.connect(unitOutputPort);
            this.preEffect = this.processor.output;
        }
        this.wireBypass();
    }

    protected void wireBypass() {
        this.preEffect.connect(0, this.output.inputA, 0);
        this.preEffect.connect(1, this.output.inputB, 0);
    }

    protected void removeEffect() {
        if (this.effect != null) {
            this.wireBypass();
            ((UnitFilter)this.effect.left).output.disconnect(this.output.inputA);
            ((UnitFilter)this.effect.right).output.disconnect(this.output.inputB);
            ((UnitFilter)this.effect.left).input.disconnect(0, this.preEffect, 0);
            ((UnitFilter)this.effect.right).input.disconnect(0, this.preEffect, 1);
            this.effect = null;
        }
    }

    protected void setEffect(Effect<? extends UnitFilter> effect) {
        this.effect = effect;
        this.preEffect.connect(0, ((UnitFilter)this.effect.left).input, 0);
        this.preEffect.connect(1, ((UnitFilter)this.effect.right).input, 0);
        ((UnitFilter)this.effect.left).output.connect(this.output.inputA);
        this.preEffect.disconnect(0, this.output.inputA, 0);
        ((UnitFilter)this.effect.right).output.connect(this.output.inputB);
        this.preEffect.disconnect(1, this.output.inputB, 0);
    }

    public UnitOutputPort getOutput() {
        return this.output.output;
    }
}

