/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import com.jsyn.data.FloatSample;
import com.jsyn.util.SampleLoader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import processing.core.PApplet;
import processing.sound.AudioSample;
import processing.sound.Engine;

public class SoundFile
extends AudioSample {
    protected static Map<String, FloatSample> SAMPLECACHE = new HashMap<String, FloatSample>();

    public SoundFile(PApplet pApplet, String string) {
        this(pApplet, string, true);
    }

    public SoundFile(PApplet pApplet, String string, boolean bl) {
        super(pApplet);
        this.sample = SAMPLECACHE.get(string);
        if (this.sample == null) {
            InputStream inputStream = pApplet.createInput(string);
            if (inputStream == null) {
                Engine.printError("unable to find file " + string);
                return;
            }
            try {
                this.sample = SampleLoader.loadFloatSample((InputStream)inputStream);
            }
            catch (IOException iOException) {
                try {
                    int n;
                    AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(pApplet.createInput(string));
                    AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioInputStream.getFormat().getSampleRate(), 16, audioInputStream.getFormat().getChannels(), audioInputStream.getFormat().getChannels() * 2, audioInputStream.getFormat().getSampleRate(), false);
                    AudioInputStream audioInputStream2 = AudioSystem.getAudioInputStream(audioFormat, audioInputStream);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] byArray = new byte[65536];
                    while ((n = audioInputStream2.read(byArray, 0, byArray.length)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n);
                    }
                    byteArrayOutputStream.flush();
                    float[] fArray = new float[byteArrayOutputStream.size() / 2];
                    SampleLoader.decodeLittleI16ToF32((byte[])byteArrayOutputStream.toByteArray(), (int)0, (int)byteArrayOutputStream.size(), (float[])fArray, (int)0);
                    this.sample = new FloatSample(fArray, audioInputStream2.getFormat().getChannels());
                    this.sample.setFrameRate((double)audioInputStream2.getFormat().getSampleRate());
                    inputStream.close();
                }
                catch (IOException iOException2) {
                    Engine.printError("unable to decode sound file " + string);
                    return;
                }
                catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                    throw new RuntimeException(unsupportedAudioFileException);
                }
            }
            if (bl) {
                SAMPLECACHE.put(string, this.sample);
            }
        }
        this.initiatePlayer();
    }

    public boolean removeFromCache() {
        return SAMPLECACHE.values().remove(this.sample);
    }

    @Override
    public int channels() {
        return super.channels();
    }

    @Override
    public void cue(float f) {
        super.cue(f);
    }

    @Override
    public float duration() {
        return super.duration();
    }

    @Override
    public int frames() {
        return super.frames();
    }

    @Override
    public void play() {
        super.play();
    }

    @Override
    public void play(float f) {
        super.play(f);
    }

    @Override
    public void play(float f, float f2) {
        super.play(f, f2);
    }

    @Override
    public void play(float f, float f2, float f3) {
        super.play(f, f2, f3);
    }

    @Override
    public void play(float f, float f2, float f3, float f4) {
        super.play(f, f2, f3, f4);
    }

    @Override
    public void play(float f, float f2, float f3, float f4, float f5) {
        super.play(f, f2, f3, f4, f5);
    }

    @Override
    public void jump(float f) {
        super.jump(f);
    }

    @Override
    public void pause() {
        super.pause();
    }

    @Override
    public boolean isPlaying() {
        return super.isPlaying();
    }

    @Override
    public void loop() {
        super.loop();
    }

    @Override
    public void loop(float f) {
        super.loop(f);
    }

    @Override
    public void loop(float f, float f2) {
        super.loop(f, f2);
    }

    @Override
    public void loop(float f, float f2, float f3) {
        super.loop(f, f2, f3);
    }

    @Override
    public void loop(float f, float f2, float f3, float f4) {
        super.loop(f, f2, f3, f4);
    }

    @Override
    public void amp(float f) {
        super.amp(f);
    }

    @Override
    public void pan(float f) {
        super.pan(f);
    }

    @Override
    public void rate(float f) {
        super.rate(f);
    }
}

