/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.io.File;
import processing.awt.ShimAWT;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PSurface;

public class PSurfaceNone
implements PSurface {
    protected PApplet sketch;
    protected PGraphics graphics;
    protected Thread thread;
    protected boolean paused;
    protected Object pauseObject = new Object();
    protected float frameRateTarget = 60.0f;
    protected long frameRatePeriod = 16666666L;

    public PSurfaceNone(PGraphics graphics) {
        this.graphics = graphics;
    }

    public int displayDensity() {
        return 1;
    }

    public int displayDensity(int display) {
        return 1;
    }

    @Override
    public PImage loadImage(String path, Object ... args) {
        return ShimAWT.loadImage(this.sketch, path, args);
    }

    @Override
    public void selectInput(String prompt, String callback, File file, Object callbackObject) {
    }

    @Override
    public void selectOutput(String prompt, String callback, File file, Object callbackObject) {
    }

    @Override
    public void selectFolder(String prompt, String callback, File file, Object callbackObject) {
    }

    @Override
    public void initOffscreen(PApplet sketch) {
        this.sketch = sketch;
        this.setSize(sketch.sketchWidth(), sketch.sketchHeight());
    }

    @Override
    public void initFrame(PApplet sketch) {
        throw new IllegalStateException("initFrame() not available with " + this.getClass().getSimpleName());
    }

    @Override
    public Object getNative() {
        return null;
    }

    @Override
    public void setTitle(String title) {
    }

    @Override
    public void setIcon(PImage image) {
    }

    @Override
    public void setVisible(boolean visible) {
    }

    @Override
    public void setResizable(boolean resizable) {
    }

    @Override
    public void placeWindow(int[] location, int[] editorLocation) {
    }

    @Override
    public void placePresent(int stopColor) {
    }

    @Override
    public void setAlwaysOnTop(boolean always) {
    }

    @Override
    public void setLocation(int x, int y) {
    }

    @Override
    public void setSize(int wide, int high) {
        if (wide == this.sketch.width && high == this.sketch.height) {
            return;
        }
        this.sketch.width = wide;
        this.sketch.height = high;
        this.graphics.setSize(wide, high);
    }

    @Override
    public void setCursor(int kind) {
    }

    @Override
    public void setCursor(PImage image, int hotspotX, int hotspotY) {
    }

    @Override
    public void showCursor() {
    }

    @Override
    public void hideCursor() {
    }

    @Override
    public boolean openLink(String url) {
        return false;
    }

    public Thread createThread() {
        return new AnimationThread();
    }

    @Override
    public void startThread() {
        if (this.thread != null) {
            throw new IllegalStateException("Thread already started in " + this.getClass().getSimpleName());
        }
        this.thread = this.createThread();
        this.thread.start();
    }

    @Override
    public boolean stopThread() {
        if (this.thread == null) {
            return false;
        }
        this.thread = null;
        return true;
    }

    @Override
    public boolean isStopped() {
        return this.thread == null || !this.thread.isAlive();
    }

    @Override
    public void pauseThread() {
        PApplet.debug("PApplet.run() paused, calling object wait...");
        this.paused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPause() {
        if (this.paused) {
            Object object = this.pauseObject;
            synchronized (object) {
                try {
                    this.pauseObject.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeThread() {
        this.paused = false;
        Object object = this.pauseObject;
        synchronized (object) {
            this.pauseObject.notifyAll();
        }
    }

    @Override
    public void setFrameRate(float fps) {
        this.frameRateTarget = fps;
        this.frameRatePeriod = (long)(1.0E9 / (double)this.frameRateTarget);
    }

    public class AnimationThread
    extends Thread {
        public AnimationThread() {
            super("Animation Thread");
        }

        public void callDraw() {
            PSurfaceNone.this.sketch.handleDraw();
        }

        @Override
        public void run() {
            long beforeTime = System.nanoTime();
            long overSleepTime = 0L;
            int noDelays = 0;
            int NO_DELAYS_PER_YIELD = 15;
            PSurfaceNone.this.sketch.start();
            while (Thread.currentThread() == PSurfaceNone.this.thread && !PSurfaceNone.this.sketch.finished) {
                PSurfaceNone.this.checkPause();
                this.callDraw();
                long afterTime = System.nanoTime();
                long timeDiff = afterTime - beforeTime;
                long sleepTime = PSurfaceNone.this.frameRatePeriod - timeDiff - overSleepTime;
                if (sleepTime > 0L) {
                    try {
                        Thread.sleep(sleepTime / 1000000L, (int)(sleepTime % 1000000L));
                        noDelays = 0;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    overSleepTime = System.nanoTime() - afterTime - sleepTime;
                } else {
                    overSleepTime = 0L;
                    if (++noDelays > 15) {
                        Thread.yield();
                        noDelays = 0;
                    }
                }
                beforeTime = System.nanoTime();
            }
            PSurfaceNone.this.sketch.dispose();
            if (PSurfaceNone.this.sketch.exitCalled) {
                PSurfaceNone.this.sketch.exitActual();
            }
        }
    }
}

