/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.data;

public class Spectrum {
    private double[] real;
    private double[] imaginary;
    public static final int DEFAULT_SIZE_LOG_2 = 9;
    public static final int DEFAULT_SIZE = 512;

    public Spectrum() {
        this(512);
    }

    public Spectrum(int size) {
        this.setSize(size);
    }

    public double[] getReal() {
        return this.real;
    }

    public double[] getImaginary() {
        return this.imaginary;
    }

    public void setSize(int size) {
        if (this.real == null || this.real.length != size) {
            this.real = new double[size];
            this.imaginary = new double[size];
        }
    }

    public int size() {
        return this.real.length;
    }

    public void copyTo(Spectrum destination) {
        assert (this.size() == destination.size());
        System.arraycopy(this.real, 0, destination.real, 0, this.real.length);
        System.arraycopy(this.imaginary, 0, destination.imaginary, 0, this.imaginary.length);
    }

    public void clear() {
        for (int i = 0; i < this.real.length; ++i) {
            this.real[i] = 0.0;
            this.imaginary[i] = 0.0;
        }
    }
}

