/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.io;

import com.jsyn.io.AudioInputStream;
import com.jsyn.io.AudioOutputStream;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class AudioFifo
implements AudioInputStream,
AudioOutputStream {
    private volatile int readIndex;
    private volatile int writeIndex;
    private volatile double[] buffer;
    private int accessMask;
    private int sizeMask;
    private boolean writeWaitEnabled = true;
    private boolean readWaitEnabled = true;
    private volatile boolean mOpen = true;
    final Lock lock = new ReentrantLock();
    final Condition notFull = this.lock.newCondition();
    final Condition notEmpty = this.lock.newCondition();

    public void allocate(int size) {
        if (!AudioFifo.isPowerOfTwo(size)) {
            throw new IllegalArgumentException("Size must be a power of two.");
        }
        this.buffer = new double[size];
        this.accessMask = size - 1;
        this.sizeMask = size * 2 - 1;
    }

    public int size() {
        return this.buffer.length;
    }

    public static boolean isPowerOfTwo(int size) {
        return (size & size - 1) == 0;
    }

    @Override
    public int available() {
        return this.writeIndex - this.readIndex & this.sizeMask;
    }

    @Override
    public void close() {
        this.mOpen = false;
        this.lock.lock();
        this.notEmpty.signal();
        this.notFull.signal();
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public double read() {
        value = NaN;
        if (this.readWaitEnabled) {
            this.lock.lock();
            try {
                while (this.mOpen && this.available() < 1) {
                    try {
                        this.notEmpty.await();
                    }
                    catch (InterruptedException e) {
                        var4_3 = NaN;
                        this.lock.unlock();
                        return var4_3;
                    }
                }
                if (!this.mOpen) ** GOTO lbl21
                value = this.readOneInternal();
            }
            finally {
                this.lock.unlock();
            }
        } else if (this.mOpen && this.readIndex != this.writeIndex) {
            value = this.readOneInternal();
        }
lbl21:
        // 5 sources

        if (this.writeWaitEnabled) {
            this.lock.lock();
            this.notFull.signal();
            this.lock.unlock();
        }
        return value;
    }

    private double readOneInternal() {
        double value = this.buffer[this.readIndex & this.accessMask];
        this.readIndex = this.readIndex + 1 & this.sizeMask;
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void write(double value) {
        if (this.writeWaitEnabled) {
            this.lock.lock();
            try {
                while (this.mOpen && this.available() == this.buffer.length) {
                    try {
                        this.notFull.await();
                    }
                    catch (InterruptedException e) {
                        this.lock.unlock();
                        return;
                    }
                }
                if (!this.mOpen) ** GOTO lbl19
                this.writeOneInternal(value);
            }
            finally {
                this.lock.unlock();
            }
        } else if (this.available() != this.buffer.length) {
            this.writeOneInternal(value);
        }
lbl19:
        // 5 sources

        if (this.readWaitEnabled) {
            this.lock.lock();
            this.notEmpty.signal();
            this.lock.unlock();
        }
    }

    private void writeOneInternal(double value) {
        this.buffer[this.writeIndex & this.accessMask] = value;
        this.writeIndex = this.writeIndex + 1 & this.sizeMask;
    }

    @Override
    public int read(double[] buffer) {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(double[] buffer, int start, int count) {
        double value;
        if (!this.mOpen) {
            return 0;
        }
        if (!this.readWaitEnabled) {
            count = Math.min(this.available(), count);
        }
        int numRead = 0;
        for (int i = 0; this.mOpen && i < count && !Double.isNaN(value = this.read()); ++i) {
            buffer[i + start] = value;
            ++numRead;
        }
        return numRead;
    }

    @Override
    public void write(double[] buffer) {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(double[] buffer, int start, int count) {
        for (int i = 0; i < count; ++i) {
            this.write(buffer[i + start]);
        }
    }

    public void setWriteWaitEnabled(boolean enabled) {
        this.writeWaitEnabled = enabled;
    }

    public void setReadWaitEnabled(boolean enabled) {
        this.readWaitEnabled = enabled;
    }

    public boolean isWriteWaitEnabled() {
        return this.writeWaitEnabled;
    }

    public boolean isReadWaitEnabled() {
        return this.readWaitEnabled;
    }
}

