/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.ports;

import com.jsyn.ports.PortBlockPart;
import com.jsyn.ports.UnitPort;

public class UnitBlockPort
extends UnitPort {
    PortBlockPart[] parts;

    public UnitBlockPort(int numParts, String name, double defaultValue) {
        super(name);
        this.makeParts(numParts, defaultValue);
    }

    public UnitBlockPort(String name) {
        this(1, name, 0.0);
    }

    protected void makeParts(int numParts, double defaultValue) {
        this.parts = new PortBlockPart[numParts];
        for (int i = 0; i < numParts; ++i) {
            this.parts[i] = new PortBlockPart(this, defaultValue);
        }
    }

    @Override
    public int getNumParts() {
        return this.parts.length;
    }

    public double get() {
        return this.get(0);
    }

    public double getValue() {
        return this.getValue(0);
    }

    public double[] getValues() {
        return this.parts[0].getValues();
    }

    public double[] getValues(int partNum) {
        return this.parts[partNum].getValues();
    }

    public double getValue(int partNum) {
        return this.parts[partNum].getValue();
    }

    public double get(int partNum) {
        return this.parts[partNum].get();
    }

    protected void setValueInternal(int partNum, double value) {
        this.parts[partNum].setValue(value);
    }

    public void setValueInternal(double value) {
        this.setValueInternal(0, value);
    }

    public boolean isConnected() {
        return this.isConnected(0);
    }

    public boolean isConnected(int partNum) {
        return this.parts[partNum].isConnected();
    }

    public void disconnectAll(int partNum) {
        this.parts[partNum].disconnectAll();
    }

    public void disconnectAll() {
        this.disconnectAll(0);
    }
}

