/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.swing;

import com.jsyn.swing.PresetSelectionListener;
import com.jsyn.util.InstrumentLibrary;
import com.jsyn.util.VoiceDescription;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class InstrumentBrowser
extends JPanel {
    private InstrumentLibrary library;
    private JScrollPane listScroller2;
    private VoiceDescription voiceDescription;
    private ArrayList<PresetSelectionListener> listeners = new ArrayList();

    public InstrumentBrowser(InstrumentLibrary library) {
        this.library = library;
        JPanel horizontalPanel = new JPanel();
        horizontalPanel.setLayout(new GridLayout(1, 2));
        final JList<VoiceDescription> instrumentList = new JList<VoiceDescription>(library.getVoiceDescriptions());
        this.setupList(instrumentList);
        instrumentList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int n;
                if (!e.getValueIsAdjusting() && (n = instrumentList.getSelectedIndex()) >= 0) {
                    InstrumentBrowser.this.showPresetList(n);
                }
            }
        });
        JScrollPane listScroller1 = new JScrollPane(instrumentList);
        listScroller1.setPreferredSize(new Dimension(250, 120));
        this.add(listScroller1);
        instrumentList.setSelectedIndex(0);
    }

    public void addPresetSelectionListener(PresetSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removePresetSelectionListener(PresetSelectionListener listener) {
        this.listeners.remove(listener);
    }

    private void firePresetSelectionListeners(VoiceDescription voiceDescription, int presetIndex) {
        for (PresetSelectionListener listener : this.listeners) {
            listener.presetSelected(voiceDescription, presetIndex);
        }
    }

    private void showPresetList(int n) {
        if (this.listScroller2 != null) {
            this.remove(this.listScroller2);
        }
        this.voiceDescription = this.library.getVoiceDescriptions()[n];
        final JList<String> presetList = new JList<String>(this.voiceDescription.getPresetNames());
        this.setupList(presetList);
        presetList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int n;
                if (!e.getValueIsAdjusting() && (n = presetList.getSelectedIndex()) >= 0) {
                    InstrumentBrowser.this.firePresetSelectionListeners(InstrumentBrowser.this.voiceDescription, n);
                }
            }
        });
        this.listScroller2 = new JScrollPane(presetList);
        this.listScroller2.setPreferredSize(new Dimension(250, 120));
        this.add(this.listScroller2);
        presetList.setSelectedIndex(0);
        this.validate();
    }

    private void setupList(JList list) {
        list.setSelectionMode(1);
        list.setLayoutOrientation(0);
        list.setVisibleRowCount(-1);
    }
}

