/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.swing;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.swing.DoubleBoundedRangeModel;
import com.jsyn.swing.ExponentialRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PortModelFactory {
    private static final int RESOLUTION = 1000000;

    public static DoubleBoundedRangeModel createLinearModel(final UnitInputPort pPort) {
        final DoubleBoundedRangeModel model = new DoubleBoundedRangeModel(pPort.getName(), 1000000, pPort.getMinimum(), pPort.getMaximum(), pPort.get());
        model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                pPort.set(model.getDoubleValue());
            }
        });
        return model;
    }

    public static ExponentialRangeModel createExponentialModel(final UnitInputPort pPort) {
        final ExponentialRangeModel model = new ExponentialRangeModel(pPort.getName(), 1000000, pPort.getMinimum(), pPort.getMaximum(), pPort.get());
        model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                pPort.set(model.getDoubleValue());
            }
        });
        return model;
    }

    public static ExponentialRangeModel createExponentialModel(final int partNum, final UnitInputPort pPort) {
        final ExponentialRangeModel model = new ExponentialRangeModel(pPort.getName(), 1000000, pPort.getMinimum(), pPort.getMaximum(), pPort.get());
        model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                pPort.set(partNum, model.getDoubleValue());
            }
        });
        return model;
    }
}

