/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.unitgen.MixerStereo;
import com.jsyn.unitgen.Unzipper;

public class MixerStereoRamped
extends MixerStereo {
    private Unzipper[] gainUnzippers;
    private Unzipper[] panUnzippers;
    private Unzipper amplitudeUnzipper;

    public MixerStereoRamped(int numInputs) {
        super(numInputs);
        int i;
        this.gainUnzippers = new Unzipper[numInputs];
        for (i = 0; i < numInputs; ++i) {
            this.gainUnzippers[i] = new Unzipper();
        }
        this.panUnzippers = new Unzipper[numInputs];
        for (i = 0; i < numInputs; ++i) {
            this.panUnzippers[i] = new Unzipper();
        }
        this.amplitudeUnzipper = new Unzipper();
    }

    @Override
    public void generate(int start, int limit) {
        double[] amplitudes = this.amplitude.getValues(0);
        double[] outputs0 = this.output.getValues(0);
        double[] outputs1 = this.output.getValues(1);
        for (int i = start; i < limit; ++i) {
            double sum0 = 0.0;
            double sum1 = 0.0;
            for (int n = 0; n < this.input.getNumParts(); ++n) {
                double[] inputs = this.input.getValues(n);
                double[] gains = this.gain.getValues(n);
                double[] pans = this.pan.getValues(n);
                MixerStereo.PanTracker panTracker = this.panTrackers[n];
                double smoothPan = this.panUnzippers[n].smooth(pans[i]);
                panTracker.update(smoothPan);
                double smoothGain = this.gainUnzippers[n].smooth(gains[i]);
                double scaledInput = inputs[i] * smoothGain;
                sum0 += scaledInput * panTracker.leftGain;
                sum1 += scaledInput * panTracker.rightGain;
            }
            double amp = this.amplitudeUnzipper.smooth(amplitudes[i]);
            outputs0[i] = sum0 * amp;
            outputs1[i] = sum1 * amp;
        }
    }
}

