/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.ports.UnitPort;
import com.jsyn.unitgen.Circuit;
import com.jsyn.unitgen.Multiply;
import com.jsyn.unitgen.PassThrough;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.unitgen.UnitSource;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.util.Instrument;
import com.jsyn.util.VoiceAllocator;
import com.softsynth.shared.time.TimeStamp;

public class PolyphonicInstrument
extends Circuit
implements UnitSource,
Instrument {
    private Multiply mixer;
    private UnitVoice[] voices;
    private VoiceAllocator voiceAllocator;
    public UnitInputPort amplitude;

    public PolyphonicInstrument(UnitVoice[] voices) {
        this.voices = voices;
        this.voiceAllocator = new VoiceAllocator(voices);
        this.mixer = new Multiply();
        this.add(this.mixer);
        for (UnitVoice voice : voices) {
            UnitGenerator unit = voice.getUnitGenerator();
            boolean wasEnabled = unit.isEnabled();
            this.add(unit);
            voice.getOutput().connect(this.mixer.inputA);
            unit.setEnabled(wasEnabled);
        }
        this.amplitude = this.mixer.inputB;
        this.addPort(this.amplitude, "Amplitude");
        this.amplitude.setup(1.0E-4, 0.4, 2.0);
        this.exportAllInputPorts();
    }

    public void exportAllInputPorts() {
        for (UnitPort port : this.voices[0].getUnitGenerator().getPorts()) {
            UnitInputPort inputPort;
            String voicePortName;
            if (!(port instanceof UnitInputPort) || (voicePortName = (inputPort = (UnitInputPort)port).getName()).equals("Frequency") || voicePortName.equals("Amplitude")) continue;
            this.exportNamedInputPort(voicePortName);
        }
    }

    public void exportNamedInputPort(String portName) {
        UnitInputPort voicePort = null;
        PassThrough fanout = new PassThrough();
        for (UnitVoice voice : this.voices) {
            voicePort = (UnitInputPort)voice.getUnitGenerator().getPortByName(portName);
            fanout.output.connect(voicePort);
        }
        if (voicePort != null) {
            this.addPort(fanout.input, portName);
            fanout.input.setup(voicePort);
        }
    }

    @Override
    public UnitOutputPort getOutput() {
        return this.mixer.output;
    }

    @Override
    public void usePreset(int presetIndex) {
        this.usePreset(presetIndex, this.getSynthesisEngine().createTimeStamp());
    }

    @Override
    public void usePreset(int presetIndex, TimeStamp timeStamp) {
        for (UnitVoice voice : this.voices) {
            voice.usePreset(presetIndex);
        }
        for (UnitPort port : this.voices[0].getUnitGenerator().getPorts()) {
            UnitInputPort inputPort;
            UnitInputPort fanPort;
            if (!(port instanceof UnitInputPort) || (fanPort = (UnitInputPort)this.getPortByName((inputPort = (UnitInputPort)port).getName())) == null || fanPort == this.amplitude) continue;
            fanPort.set(inputPort.get());
        }
    }

    @Override
    public void noteOn(int tag, double frequency, double amplitude, TimeStamp timeStamp) {
        this.voiceAllocator.noteOn(tag, frequency, amplitude, timeStamp);
    }

    @Override
    public void noteOff(int tag, TimeStamp timeStamp) {
        this.voiceAllocator.noteOff(tag, timeStamp);
    }

    @Override
    public void setPort(int tag, String portName, double value, TimeStamp timeStamp) {
        this.voiceAllocator.setPort(tag, portName, value, timeStamp);
    }

    @Override
    public void allNotesOff(TimeStamp timeStamp) {
        this.voiceAllocator.allNotesOff(timeStamp);
    }

    public synchronized boolean isOn(int tag) {
        return this.voiceAllocator.isOn(tag);
    }
}

